// Author: Sally Hudson
// This program estimates ATE using the propensity score matching procedure in Hirano, Imbens & Ridder (2003).

program hir, eclass
	
	syntax varlist
		
	preserve
	
	// parse command
	tokenize `varlist'
	tempvar y d p delta
	qui gen `y' = `1'
	qui gen `d' = `2'
	qui gen `p' = `3'
		
	// generate HIR estimate
	qui gen `delta' = ((`y'*`d')/`p' - (`y'*(1-`d'))/(1-`p'))
	qui sum `delta'
	
	// return results
	ereturn scalar ate = r(mean)
	restore

end

	